"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addPathMapping = void 0;
const devkit_1 = require("@nrwl/devkit");
const typescript_1 = require("@nrwl/workspace/src/utilities/typescript");
function addPathMapping(tree, options) {
    (0, devkit_1.updateJson)(tree, (0, typescript_1.getRootTsConfigPathInTree)(tree), (json) => {
        const c = json.compilerOptions;
        c.paths = c.paths || {};
        c.paths[options.secondaryEntryPoint] = [
            `${options.libraryProject.root}/${options.name}/src/index.ts`,
        ];
        return json;
    });
}
exports.addPathMapping = addPathMapping;
//# sourceMappingURL=add-path-mapping.js.map