"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.karmaGenerator = void 0;
const devkit_1 = require("@nrwl/devkit");
function karmaGenerator(tree, options) {
    const packageJson = (0, devkit_1.readJson)(tree, 'package.json');
    if (!tree.exists('karma.conf.js')) {
        (0, devkit_1.generateFiles)(tree, (0, devkit_1.joinPathFragments)(__dirname, 'files'), '.', {
            tmpl: '',
        });
    }
    if (options.skipPackageJson || packageJson.devDependencies['karma']) {
        return () => { };
    }
    return (0, devkit_1.addDependenciesToPackageJson)(tree, {}, {
        karma: '~6.3.0',
        'karma-chrome-launcher': '~3.1.0',
        'karma-coverage': '~2.2.0',
        'karma-jasmine': '~4.0.0',
        'karma-jasmine-html-reporter': '~1.7.0',
        'jasmine-core': '~3.10.0',
        'jasmine-spec-reporter': '~5.0.0',
        '@types/jasmine': '~3.5.0',
    });
}
exports.karmaGenerator = karmaGenerator;
exports.default = karmaGenerator;
//# sourceMappingURL=karma.js.map