"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateWorkspaceConfig = void 0;
const devkit_1 = require("@nrwl/devkit");
function updateWorkspaceConfig(tree, project) {
    const projectConfig = (0, devkit_1.readProjectConfiguration)(tree, project);
    projectConfig.targets.test = {
        executor: '@angular-devkit/build-angular:karma',
        options: {
            main: (0, devkit_1.joinPathFragments)(projectConfig.sourceRoot, 'test.ts'),
            tsConfig: (0, devkit_1.joinPathFragments)(projectConfig.root, 'tsconfig.spec.json'),
            karmaConfig: (0, devkit_1.joinPathFragments)(projectConfig.root, 'karma.conf.js'),
        },
    };
    if (projectConfig.projectType === 'application') {
        projectConfig.targets.test.options = Object.assign(Object.assign({}, projectConfig.targets.test.options), { polyfills: (0, devkit_1.joinPathFragments)(projectConfig.sourceRoot, 'polyfills.ts'), styles: [], scripts: [], assets: [] });
    }
    if (projectConfig.targets.lint &&
        projectConfig.targets.lint.executor ===
            '@angular-devkit/build-angular:tslint') {
        projectConfig.targets.lint.options.tsConfig = [
            ...projectConfig.targets.lint.options.tsConfig,
            (0, devkit_1.joinPathFragments)(projectConfig.root, 'tsconfig.spec.json'),
        ];
    }
    (0, devkit_1.updateProjectConfiguration)(tree, project, projectConfig);
}
exports.updateWorkspaceConfig = updateWorkspaceConfig;
//# sourceMappingURL=update-workspace-config.js.map