"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateTsConfigs = void 0;
const devkit_1 = require("@nrwl/devkit");
function updateTsConfigs(tree, project) {
    const projectConfig = (0, devkit_1.readProjectConfiguration)(tree, project);
    (0, devkit_1.updateJson)(tree, (0, devkit_1.joinPathFragments)(projectConfig.root, 'tsconfig.json'), (json) => {
        return Object.assign(Object.assign({}, json), { references: [
                ...(json.references || []),
                {
                    path: './tsconfig.spec.json',
                },
            ] });
    });
    const extraFiles = projectConfig.projectType === 'library' ? [] : ['src/polyfills.ts'];
    return (0, devkit_1.updateJson)(tree, (0, devkit_1.joinPathFragments)(projectConfig.root, 'tsconfig.spec.json'), (json) => {
        return Object.assign(Object.assign({}, json), { files: [...json.files, ...extraFiles] });
    });
}
exports.updateTsConfigs = updateTsConfigs;
//# sourceMappingURL=update-tsconfig.js.map