"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.karmaProjectGenerator = void 0;
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const check_test_target_1 = require("./lib/check-test-target");
const generate_karma_project_files_1 = require("./lib/generate-karma-project-files");
const update_tsconfig_1 = require("./lib/update-tsconfig");
const update_workspace_config_1 = require("./lib/update-workspace-config");
const karma_1 = require("../karma/karma");
function karmaProjectGenerator(tree, options) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        (0, karma_1.karmaGenerator)(tree, options);
        (0, check_test_target_1.checkProjectTestTarget)(tree, options.project);
        (0, generate_karma_project_files_1.generateKarmaProjectFiles)(tree, options.project);
        (0, update_tsconfig_1.updateTsConfigs)(tree, options.project);
        (0, update_workspace_config_1.updateWorkspaceConfig)(tree, options.project);
        if (!options.skipFormat) {
            yield (0, devkit_1.formatFiles)(tree);
        }
    });
}
exports.karmaProjectGenerator = karmaProjectGenerator;
exports.default = karmaProjectGenerator;
//# sourceMappingURL=karma-project.js.map