"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.angularInitGenerator = void 0;
const tslib_1 = require("tslib");
const cypress_1 = require("@nrwl/cypress");
const devkit_1 = require("@nrwl/devkit");
const devkit_2 = require("@nrwl/devkit");
const jest_1 = require("@nrwl/jest");
const linter_1 = require("@nrwl/linter");
const run_tasks_in_serial_1 = require("@nrwl/workspace/src/utilities/run-tasks-in-serial");
const set_default_collection_1 = require("@nrwl/workspace/src/utilities/set-default-collection");
const versions_1 = require("../../utils/versions");
const karma_1 = require("../karma/karma");
function angularInitGenerator(host, rawOptions) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const options = normalizeOptions(rawOptions);
        setDefaults(host, options);
        addPostInstall(host);
        const depsTask = !options.skipPackageJson
            ? updateDependencies(host)
            : () => { };
        const unitTestTask = addUnitTestRunner(host, options);
        const e2eTask = addE2ETestRunner(host, options);
        addGitIgnoreEntry(host, '.angular');
        if (!options.skipFormat) {
            yield (0, devkit_2.formatFiles)(host);
        }
        return (0, run_tasks_in_serial_1.runTasksInSerial)(depsTask, unitTestTask, e2eTask);
    });
}
exports.angularInitGenerator = angularInitGenerator;
function normalizeOptions(options) {
    var _a, _b, _c, _d, _e, _f, _g;
    return {
        e2eTestRunner: (_a = options.e2eTestRunner) !== null && _a !== void 0 ? _a : "cypress" /* Cypress */,
        linter: (_b = options.linter) !== null && _b !== void 0 ? _b : linter_1.Linter.EsLint,
        skipFormat: (_c = options.skipFormat) !== null && _c !== void 0 ? _c : false,
        skipInstall: (_d = options.skipInstall) !== null && _d !== void 0 ? _d : false,
        skipPackageJson: (_e = options.skipPackageJson) !== null && _e !== void 0 ? _e : false,
        style: (_f = options.style) !== null && _f !== void 0 ? _f : 'css',
        unitTestRunner: (_g = options.unitTestRunner) !== null && _g !== void 0 ? _g : "jest" /* Jest */,
    };
}
function setDefaults(host, options) {
    const workspace = (0, devkit_2.readWorkspaceConfiguration)(host);
    workspace.generators = workspace.generators || {};
    workspace.generators['@nrwl/angular:application'] = Object.assign({ style: options.style, linter: options.linter, unitTestRunner: options.unitTestRunner, e2eTestRunner: options.e2eTestRunner }, (workspace.generators['@nrwl/angular:application'] || {}));
    workspace.generators['@nrwl/angular:library'] = Object.assign({ linter: options.linter, unitTestRunner: options.unitTestRunner }, (workspace.generators['@nrwl/angular:library'] || {}));
    workspace.generators['@nrwl/angular:component'] = Object.assign({ style: options.style }, (workspace.generators['@nrwl/angular:component'] || {}));
    (0, devkit_2.updateWorkspaceConfiguration)(host, workspace);
    (0, set_default_collection_1.setDefaultCollection)(host, '@nrwl/angular');
}
function addPostInstall(host) {
    (0, devkit_2.updateJson)(host, 'package.json', (pkgJson) => {
        var _a;
        pkgJson.scripts = (_a = pkgJson.scripts) !== null && _a !== void 0 ? _a : {};
        const command = 'ngcc --properties es2015 browser module main';
        if (!pkgJson.scripts.postinstall) {
            pkgJson.scripts.postinstall = command;
        }
        else if (!pkgJson.scripts.postinstall.includes('ngcc')) {
            pkgJson.scripts.postinstall = `${pkgJson.scripts.postinstall} && ${command}`;
        }
        return pkgJson;
    });
}
function updateDependencies(host) {
    return (0, devkit_2.addDependenciesToPackageJson)(host, {
        '@angular/animations': versions_1.angularVersion,
        '@angular/common': versions_1.angularVersion,
        '@angular/compiler': versions_1.angularVersion,
        '@angular/core': versions_1.angularVersion,
        '@angular/forms': versions_1.angularVersion,
        '@angular/platform-browser': versions_1.angularVersion,
        '@angular/platform-browser-dynamic': versions_1.angularVersion,
        '@angular/router': versions_1.angularVersion,
        rxjs: versions_1.rxjsVersion,
        tslib: '^2.0.0',
        'zone.js': '~0.11.4',
    }, {
        '@angular/cli': versions_1.angularDevkitVersion,
        '@angular/compiler-cli': versions_1.angularVersion,
        '@angular/language-service': versions_1.angularVersion,
        '@angular-devkit/build-angular': versions_1.angularDevkitVersion,
    });
}
function addUnitTestRunner(host, options) {
    switch (options.unitTestRunner) {
        case "karma" /* Karma */:
            return (0, karma_1.karmaGenerator)(host, { skipPackageJson: options.skipPackageJson });
        case "jest" /* Jest */:
            if (!options.skipPackageJson) {
                (0, devkit_2.addDependenciesToPackageJson)(host, {}, {
                    'jest-preset-angular': versions_1.jestPresetAngularVersion,
                });
            }
            return (0, jest_1.jestInitGenerator)(host, {
                skipPackageJson: options.skipPackageJson,
            });
        default:
            return () => { };
    }
}
function addE2ETestRunner(host, options) {
    switch (options.e2eTestRunner) {
        case "protractor" /* Protractor */:
            return !options.skipPackageJson
                ? (0, devkit_2.addDependenciesToPackageJson)(host, {}, {
                    protractor: '~7.0.0',
                    'jasmine-core': '~3.6.0',
                    'jasmine-spec-reporter': '~5.0.0',
                    'ts-node': '~9.1.1',
                    '@types/jasmine': '~3.6.0',
                    '@types/jasminewd2': '~2.0.3',
                })
                : () => { };
        case "cypress" /* Cypress */:
            return (0, cypress_1.cypressInitGenerator)(host, {
                skipPackageJson: options.skipPackageJson,
            });
        default:
            return () => { };
    }
}
function addGitIgnoreEntry(host, entry) {
    if (host.exists('.gitignore')) {
        let content = host.read('.gitignore', 'utf-8');
        if (/^\.angular$/gm.test(content)) {
            return;
        }
        content = `${content}\n${entry}\n`;
        host.write('.gitignore', content);
    }
    else {
        devkit_1.logger.warn(`Couldn't find .gitignore file to update`);
    }
}
exports.default = angularInitGenerator;
//# sourceMappingURL=init.js.map