"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateModuleBootstrap = void 0;
const ast_utils_1 = require("@nrwl/workspace/src/utilities/ast-utils");
const ast_utils_2 = require("../../../utils/nx-devkit/ast-utils");
function updateModuleBootstrap(tree, options) {
    let { modulePath, moduleSource, moduleClassName } = (0, ast_utils_2.readBootstrapInfo)(tree, options.project);
    moduleSource = (0, ast_utils_2.removeFromNgModule)(tree, moduleSource, modulePath, 'bootstrap');
    (0, ast_utils_1.addMethod)(tree, moduleSource, modulePath, {
        className: moduleClassName,
        methodHeader: 'ngDoBootstrap(): void',
    });
}
exports.updateModuleBootstrap = updateModuleBootstrap;
//# sourceMappingURL=update-module-bootstrap.js.map