"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.downgradeModuleGenerator = void 0;
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const upgrade_1 = require("../utils/upgrade");
const lib_1 = require("./lib");
function downgradeModuleGenerator(tree, rawOptions) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const options = (0, lib_1.normalizeOptions)(rawOptions);
        (0, lib_1.updateMain)(tree, options);
        (0, lib_1.addEntryComponentsToModule)(tree, options);
        (0, lib_1.updateModuleBootstrap)(tree, options);
        let installPackagesTask = () => { };
        if (!options.skipPackageJson) {
            installPackagesTask = (0, upgrade_1.addUpgradeToPackageJson)(tree);
        }
        if (!options.skipFormat) {
            yield (0, devkit_1.formatFiles)(tree);
        }
        return installPackagesTask;
    });
}
exports.downgradeModuleGenerator = downgradeModuleGenerator;
exports.default = downgradeModuleGenerator;
//# sourceMappingURL=downgrade-module.js.map