"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseASTOfWebpackConfig = void 0;
const tsquery_1 = require("@phenomnomnominal/tsquery");
function parseASTOfWebpackConfig(tree, pathToWebpackConfig) {
    if (!tree.exists(pathToWebpackConfig)) {
        throw new Error(`Cannot migrate webpack config at \`${pathToWebpackConfig}\` as it does not exist. Please ensure this file exists and that the path to the file is correct.`);
    }
    const source = tree.read(pathToWebpackConfig, 'utf-8');
    return tsquery_1.tsquery.ast(source);
}
exports.parseASTOfWebpackConfig = parseASTOfWebpackConfig;
//# sourceMappingURL=parse-ast-webpack-config.js.map