"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getExposedModulesFromRemote = exports.getRemotesFromHost = exports.isHostRemoteConfig = void 0;
const tsquery_1 = require("@phenomnomnominal/tsquery");
const REMOTES_EXPRESSION_SELECTOR = 'PropertyAssignment:has(Identifier[name=remotes]) > ObjectLiteralExpression';
const EXPOSES_EXPRESSION_SELECTOR = 'PropertyAssignment:has(Identifier[name=exposes]) > ObjectLiteralExpression';
const PROPERTY_SELECTOR = 'ObjectLiteralExpression > PropertyAssignment';
function isHostRemoteConfig(ast) {
    let isHost = false;
    let isRemote = false;
    const remotesNodes = (0, tsquery_1.tsquery)(ast, REMOTES_EXPRESSION_SELECTOR, {
        visitAllChildren: true,
    });
    if (remotesNodes.length > 0) {
        isHost = true;
    }
    const exposesNodes = (0, tsquery_1.tsquery)(ast, EXPOSES_EXPRESSION_SELECTOR, {
        visitAllChildren: true,
    });
    if (exposesNodes.length > 0) {
        isRemote = true;
    }
    let result = isHost && isRemote ? 'both' : isHost ? 'host' : isRemote ? 'remote' : false;
    return result;
}
exports.isHostRemoteConfig = isHostRemoteConfig;
function getRemotesFromHost(ast) {
    const remotesObjectNodes = (0, tsquery_1.tsquery)(ast, REMOTES_EXPRESSION_SELECTOR, {
        visitAllChildren: true,
    });
    if (remotesObjectNodes.length === 0) {
        return [];
    }
    const remotesNodes = (0, tsquery_1.tsquery)(remotesObjectNodes[0], PROPERTY_SELECTOR, {
        visitAllChildren: true,
    });
    if (remotesNodes.length === 0) {
        return [];
    }
    const remotes = [];
    for (const remoteNode of remotesNodes) {
        const remoteText = remoteNode.getText();
        const remoteParts = remoteText
            .split(':')
            .map((part) => part.trim().replace(/'/g, ''));
        const remoteName = remoteParts.shift();
        const remoteLocation = remoteParts.join(':').replace(/\/[^\/]+$/, '');
        remotes.push([remoteName, remoteLocation]);
    }
    return remotes;
}
exports.getRemotesFromHost = getRemotesFromHost;
function getExposedModulesFromRemote(ast) {
    const exposesObjectNodes = (0, tsquery_1.tsquery)(ast, EXPOSES_EXPRESSION_SELECTOR, {
        visitAllChildren: true,
    });
    if (exposesObjectNodes.length === 0) {
        return {};
    }
    return exposesObjectNodes[0].getText();
}
exports.getExposedModulesFromRemote = getExposedModulesFromRemote;
//# sourceMappingURL=is-host-remote-config.js.map