"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getWebpackConfigPath = void 0;
function getWebpackConfigPath(project, projectName) {
    var _a, _b, _c;
    let pathToWebpackConfig = '';
    for (const target of Object.values((_a = project.targets) !== null && _a !== void 0 ? _a : {})) {
        if (target.executor === '@nrwl/angular:webpack-browser' &&
            ((_b = target.options.customWebpackConfig) === null || _b === void 0 ? void 0 : _b.path)) {
            pathToWebpackConfig = (_c = target.options.customWebpackConfig) === null || _c === void 0 ? void 0 : _c.path;
            break;
        }
    }
    if (!pathToWebpackConfig) {
        throw new Error(`Could not find webpack config for \`${projectName}\` in your workspace.`);
    }
    return pathToWebpackConfig;
}
exports.getWebpackConfigPath = getWebpackConfigPath;
//# sourceMappingURL=get-webpack-config-path.js.map