"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.checkSharedNpmPackagesMatchExpected = void 0;
const tsquery_1 = require("@phenomnomnominal/tsquery");
function checkSharedNpmPackagesMatchExpected(ast) {
    const SHARE_HELPER_SELECTOR = 'PropertyAssignment:has(Identifier[name=shared]) > CallExpression:has(Identifier[name=share])';
    const SHARED_PACKAGE_CONFIG_SELECTOR = 'ObjectLiteralExpression > PropertyAssignment > ObjectLiteralExpression';
    const shareHelperNodes = (0, tsquery_1.tsquery)(ast, SHARE_HELPER_SELECTOR, {
        visitAllChildren: true,
    });
    let sharedPackageConfigNodes;
    let settingsToMatch = [];
    if (shareHelperNodes.length === 0) {
        // if we arent sharing using share helper, check for standard object sharing syntax
        const SHARED_OBJECT_SELECTOR = 'PropertyAssignment:has(Identifier[name=shared]) > ObjectLiteralExpression';
        const sharedObjectNodes = (0, tsquery_1.tsquery)(ast, SHARED_OBJECT_SELECTOR, {
            visitAllChildren: true,
        });
        if (sharedObjectNodes.length === 0) {
            // nothing is being shared, we're safe to continue
            return true;
        }
        sharedPackageConfigNodes = (0, tsquery_1.tsquery)(sharedObjectNodes[0], SHARED_PACKAGE_CONFIG_SELECTOR, { visitAllChildren: true });
        settingsToMatch = [`singleton: true`, `strictVersion: true`];
    }
    else {
        sharedPackageConfigNodes = (0, tsquery_1.tsquery)(shareHelperNodes[0], SHARED_PACKAGE_CONFIG_SELECTOR, { visitAllChildren: true });
        settingsToMatch = [
            `singleton: true`,
            `strictVersion: true`,
            `requiredVersion: 'auto'`,
        ];
    }
    if (sharedPackageConfigNodes.length === 0) {
        // we arent sharing configs with the share helper, so we can safely continue
        return true;
    }
    let packagesMatch = true;
    for (const configNode of sharedPackageConfigNodes) {
        const configText = configNode.getText();
        packagesMatch = settingsToMatch.every((setting) => configText.includes(setting));
        if (!packagesMatch) {
            break;
        }
    }
    return packagesMatch;
}
exports.checkSharedNpmPackagesMatchExpected = checkSharedNpmPackagesMatchExpected;
//# sourceMappingURL=check-shared-npm-packages.js.map