"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.componentGenerator = void 0;
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const ngcli_adapter_1 = require("@nrwl/devkit/ngcli-adapter");
const devkit_2 = require("@nrwl/devkit");
const path_1 = require("../utils/path");
function componentGenerator(tree, schema) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        checkPathUnderProjectRoot(tree, schema);
        const angularComponentSchematic = (0, ngcli_adapter_1.wrapAngularDevkitSchematic)('@schematics/angular', 'component');
        yield angularComponentSchematic(tree, Object.assign({}, schema));
        exportComponent(tree, schema);
        yield (0, devkit_2.formatFiles)(tree);
    });
}
exports.componentGenerator = componentGenerator;
function checkPathUnderProjectRoot(tree, schema) {
    var _a;
    if (!schema.path) {
        return;
    }
    const project = (_a = schema.project) !== null && _a !== void 0 ? _a : (0, devkit_2.readWorkspaceConfiguration)(tree).defaultProject;
    const { root } = (0, devkit_2.readProjectConfiguration)(tree, project);
    let pathToComponent = (0, devkit_2.normalizePath)(schema.path);
    pathToComponent = pathToComponent.startsWith('/')
        ? pathToComponent.slice(1)
        : pathToComponent;
    if (!(0, path_1.pathStartsWith)(pathToComponent, root)) {
        throw new Error(`The path provided for the component (${schema.path}) does not exist under the project root (${root}).`);
    }
}
function exportComponent(tree, schema) {
    var _a, _b, _c;
    if (!schema.export) {
        return;
    }
    const project = (_a = schema.project) !== null && _a !== void 0 ? _a : (0, devkit_2.readWorkspaceConfiguration)(tree).defaultProject;
    const { root, sourceRoot, projectType } = (0, devkit_2.readProjectConfiguration)(tree, project);
    if (projectType === 'application') {
        devkit_1.logger.warn('--export=true was ignored as the project the component being generated in is not a library.');
        return;
    }
    const componentNames = (0, devkit_1.names)(schema.name);
    const componentFileName = `${componentNames.fileName}.${(_b = schema.type) !== null && _b !== void 0 ? _b : 'component'}`;
    let componentDirectory = schema.flat
        ? (0, devkit_1.joinPathFragments)(sourceRoot, 'lib')
        : (0, devkit_1.joinPathFragments)(sourceRoot, 'lib', componentNames.fileName);
    if (schema.path) {
        componentDirectory = schema.flat
            ? (0, devkit_2.normalizePath)(schema.path)
            : (0, devkit_1.joinPathFragments)(schema.path, componentNames.fileName);
    }
    const componentFilePath = (0, devkit_1.joinPathFragments)(componentDirectory, `${componentFileName}.ts`);
    const ngPackageJsonPath = (0, devkit_1.joinPathFragments)(root, 'ng-package.json');
    const ngPackageEntryPoint = tree.exists(ngPackageJsonPath)
        ? (_c = (0, devkit_1.readJson)(tree, ngPackageJsonPath).lib) === null || _c === void 0 ? void 0 : _c.entryFile
        : undefined;
    const projectEntryPoint = ngPackageEntryPoint
        ? (0, devkit_1.joinPathFragments)(root, ngPackageEntryPoint)
        : (0, devkit_1.joinPathFragments)(sourceRoot, `index.ts`);
    if (!tree.exists(projectEntryPoint)) {
        // Let's not error, simply warn the user
        // It's not too much effort to manually do this
        // It would be more frustrating to have to find the correct path and re-run the command
        devkit_1.logger.warn(`Could not export the component in the library's entry point. Unable to determine project's entry point. The path ${projectEntryPoint} does not exist. The component has still been created.`);
        return;
    }
    const relativePathFromEntryPoint = `.${componentFilePath
        .split(sourceRoot)[1]
        .replace('.ts', '')}`;
    const updateEntryPointContent = `${tree.read(projectEntryPoint, 'utf-8')}
    export * from "${relativePathFromEntryPoint}";`;
    tree.write(projectEntryPoint, updateEntryPointContent);
}
exports.default = componentGenerator;
//# sourceMappingURL=component.js.map