"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.componentStoryGenerator = void 0;
const devkit_1 = require("@nrwl/devkit");
const storybook_1 = require("../utils/storybook");
const get_args_default_value_1 = require("./lib/get-args-default-value");
function componentStoryGenerator(tree, options) {
    const { componentFileName, componentName, componentPath, projectPath } = options;
    const templatesDir = (0, devkit_1.joinPathFragments)(__dirname, 'files');
    const destinationDir = (0, devkit_1.joinPathFragments)(projectPath, componentPath);
    const storyFile = (0, devkit_1.joinPathFragments)(destinationDir, `${componentFileName}.stories.ts`);
    if (tree.exists(storyFile)) {
        return;
    }
    const props = (0, storybook_1.getComponentProps)(tree, (0, devkit_1.joinPathFragments)(destinationDir, `${componentFileName}.ts`), get_args_default_value_1.getArgsDefaultValue);
    (0, devkit_1.generateFiles)(tree, templatesDir, destinationDir, {
        componentFileName: componentFileName,
        componentName: componentName,
        props: props.filter((p) => typeof p.defaultValue !== 'undefined'),
        tmpl: '',
    });
}
exports.componentStoryGenerator = componentStoryGenerator;
exports.default = componentStoryGenerator;
//# sourceMappingURL=component-story.js.map