"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getComponentSelector = void 0;
const typescript_1 = require("@nrwl/workspace/src/utilities/typescript");
const typescript_2 = require("typescript");
const ast_utils_1 = require("../../../utils/nx-devkit/ast-utils");
function getComponentSelector(tree, path) {
    const file = (0, ast_utils_1.getTsSourceFile)(tree, path);
    const componentDecorators = (0, ast_utils_1.getDecoratorMetadata)(file, 'Component', '@angular/core');
    if (componentDecorators.length === 0) {
        throw new Error(`No @Component decorator in ${path}.`);
    }
    const componentDecorator = componentDecorators[0];
    const selectorNode = ((0, typescript_1.findNodes)(componentDecorator, typescript_2.SyntaxKind.PropertyAssignment).find((node) => node.name.getText() === 'selector'));
    if (!selectorNode) {
        throw new Error(`No selector defined for the component in ${path}.`);
    }
    return selectorNode.initializer.getText().slice(1, -1);
}
exports.getComponentSelector = getComponentSelector;
//# sourceMappingURL=get-component-selector.js.map