"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getArgsDefaultValue = void 0;
const typescript_1 = require("typescript");
function getArgsDefaultValue(property) {
    if (!property.initializer) {
        return undefined;
    }
    switch (property.initializer.kind) {
        case typescript_1.SyntaxKind.StringLiteral:
            const returnString = property.initializer.getText().slice(1, -1);
            return returnString.replace(/\s/g, '+');
        case typescript_1.SyntaxKind.NumericLiteral:
        case typescript_1.SyntaxKind.TrueKeyword:
        case typescript_1.SyntaxKind.FalseKeyword:
            return property.initializer.getText();
        default:
            return undefined;
    }
}
exports.getArgsDefaultValue = getArgsDefaultValue;
//# sourceMappingURL=get-args-default-value.js.map