"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.componentCypressSpecGenerator = void 0;
const devkit_1 = require("@nrwl/devkit");
const storybook_1 = require("../utils/storybook");
const get_component_selector_1 = require("./lib/get-component-selector");
const get_args_default_value_1 = require("./lib/get-args-default-value");
function componentCypressSpecGenerator(tree, options) {
    const { cypressProject, projectName, projectPath, componentPath, componentFileName, componentName, } = options;
    const e2eProjectName = cypressProject || `${projectName}-e2e`;
    const e2eProjectRoot = (0, devkit_1.readProjectConfiguration)(tree, e2eProjectName).sourceRoot;
    const e2eLibIntegrationFolderPath = (0, devkit_1.joinPathFragments)(e2eProjectRoot, 'integration');
    const templatesDir = (0, devkit_1.joinPathFragments)(__dirname, 'files');
    const destinationDir = (0, devkit_1.joinPathFragments)(e2eLibIntegrationFolderPath, componentPath);
    const storyFile = (0, devkit_1.joinPathFragments)(destinationDir, `${componentFileName}.spec.ts`);
    if (tree.exists(storyFile)) {
        return;
    }
    const fullComponentPath = (0, devkit_1.joinPathFragments)(projectPath, componentPath, `${componentFileName}.ts`);
    const props = (0, storybook_1.getComponentProps)(tree, fullComponentPath, get_args_default_value_1.getArgsDefaultValue);
    const componentSelector = (0, get_component_selector_1.getComponentSelector)(tree, fullComponentPath);
    (0, devkit_1.generateFiles)(tree, templatesDir, destinationDir, {
        projectName,
        componentFileName,
        componentName,
        componentSelector,
        props,
        tmpl: '',
    });
}
exports.componentCypressSpecGenerator = componentCypressSpecGenerator;
exports.default = componentCypressSpecGenerator;
//# sourceMappingURL=component-cypress-spec.js.map