"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateNxComponentTemplate = void 0;
const ts = require("typescript");
const ast_utils_1 = require("@nrwl/workspace/src/utilities/ast-utils");
const ast_utils_2 = require("../../../utils/nx-devkit/ast-utils");
const nrwl_home_tpl_1 = require("./nrwl-home-tpl");
function updateNxComponentTemplate(host, options) {
    const componentPath = `${options.appProjectRoot}/src/app/nx-welcome.component.ts`;
    const templateNodeValue = (0, ast_utils_2.getDecoratorPropertyValueNode)(host, componentPath, 'Component', 'template', '@angular/core');
    (0, ast_utils_1.replaceNodeValue)(host, ts.createSourceFile(componentPath, host.read(componentPath, 'utf-8'), ts.ScriptTarget.Latest, true), componentPath, templateNodeValue, `\`\n${nrwl_home_tpl_1.nrwlHomeTemplate.template(options.name)}\n\``);
    // Fixing extra comma issue `,,`
    let sourceFile = ts.createSourceFile(componentPath, host.read(componentPath, 'utf-8'), ts.ScriptTarget.Latest, true);
    const componentFile = host
        .read(componentPath, 'utf-8')
        .toString()
        .replace(/,,/gi, ',');
    host.write(componentPath, componentFile);
    sourceFile.update(componentFile, {
        newLength: componentFile.length,
        span: {
            length: sourceFile.text.length,
            start: 0,
        },
    });
    // Add ESLint ignore to pass the lint step
    sourceFile = ts.createSourceFile(componentPath, host.read(componentPath, 'utf-8'), ts.ScriptTarget.Latest, true);
    (0, ast_utils_1.addGlobal)(host, sourceFile, componentPath, '/* eslint-disable */');
}
exports.updateNxComponentTemplate = updateNxComponentTemplate;
//# sourceMappingURL=update-nx-component-template.js.map