"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateE2eProject = void 0;
const devkit_1 = require("@nrwl/devkit");
const typescript_1 = require("@nrwl/workspace/src/utilities/typescript");
function updateE2eProject(tree, options) {
    const spec = `${options.e2eProjectRoot}/src/app.e2e-spec.ts`;
    const content = tree.read(spec, 'utf-8');
    tree.write(spec, content.replace(`${options.name} app is running!`, `Welcome ${options.name}`));
    const page = `${options.e2eProjectRoot}/src/app.po.ts`;
    const pageContent = tree.read(page, 'utf-8');
    tree.write(page, pageContent.replace(`.content span`, `header h1`));
    const proj = (0, devkit_1.readProjectConfiguration)(tree, options.name);
    const project = {
        root: options.e2eProjectRoot,
        projectType: 'application',
        targets: {
            e2e: proj.targets.e2e,
        },
        implicitDependencies: [options.name],
        tags: [],
    };
    project.targets.e2e.options.protractorConfig = `${options.e2eProjectRoot}/protractor.conf.js`;
    // update workspace.json / angular.json
    (0, devkit_1.addProjectConfiguration)(tree, options.e2eProjectName, project);
    delete proj.targets.e2e;
    (0, devkit_1.updateProjectConfiguration)(tree, options.name, proj);
    // update tsconfig e2e
    if (!tree.exists(`${options.e2eProjectRoot}/tsconfig.e2e.json`)) {
        tree.write(`${options.e2eProjectRoot}/tsconfig.e2e.json`, '{}');
    }
    (0, devkit_1.updateJson)(tree, `${options.e2eProjectRoot}/tsconfig.e2e.json`, (json) => {
        return Object.assign(Object.assign({}, json), { extends: `./tsconfig.json`, compilerOptions: Object.assign(Object.assign({}, json.compilerOptions), { outDir: `${(0, devkit_1.offsetFromRoot)(options.e2eProjectRoot)}dist/out-tsc` }) });
    });
    // update tsconfig
    (0, devkit_1.updateJson)(tree, `${options.e2eProjectRoot}/tsconfig.json`, (json) => {
        return Object.assign(Object.assign({}, json), { extends: (0, typescript_1.getRelativePathToRootTsConfig)(tree, options.e2eProjectRoot) });
    });
}
exports.updateE2eProject = updateE2eProject;
//# sourceMappingURL=update-e2e-project.js.map