"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateConfigFiles = void 0;
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const cli_config_utils_1 = require("@nrwl/workspace/src/utils/cli-config-utils");
function updateConfigFiles(host, options) {
    updateTsConfigOptions(host, options);
    updateAppAndE2EProjectConfigurations(host, options);
}
exports.updateConfigFiles = updateConfigFiles;
function updateTsConfigOptions(host, options) {
    // tsconfig.app.json
    (0, devkit_1.updateJson)(host, `${options.appProjectRoot}/tsconfig.app.json`, (json) => (Object.assign(Object.assign({}, json), { extends: './tsconfig.json', compilerOptions: Object.assign(Object.assign({}, json.compilerOptions), { outDir: `${(0, devkit_1.offsetFromRoot)(options.appProjectRoot)}dist/out-tsc`, target: 'ES2017' }), exclude: [
            ...new Set([...(json.exclude || []), '**/*.test.ts', '**/*.spec.ts']),
        ] })));
}
function updateAppAndE2EProjectConfigurations(host, options) {
    // workspace.json
    let project = (0, devkit_1.readProjectConfiguration)(host, options.name);
    if (options.ngCliSchematicAppRoot !== options.appProjectRoot) {
        project = (0, cli_config_utils_1.replaceAppNameWithPath)(project, options.ngCliSchematicAppRoot, options.appProjectRoot);
    }
    delete project.targets.test;
    // Ensure the outputs property comes after the executor for
    // better readability.
    const _a = project.targets.build, { executor } = _a, rest = tslib_1.__rest(_a, ["executor"]);
    project.targets.build = Object.assign({ executor, outputs: ['{options.outputPath}'] }, rest);
    if (project.generators) {
        delete project.generators;
    }
    if (options.port) {
        project.targets.serve = Object.assign(Object.assign({}, project.targets.serve), { options: Object.assign(Object.assign({}, project.targets.serve.options), { port: options.port }) });
    }
    project.tags = options.parsedTags;
    (0, devkit_1.updateProjectConfiguration)(host, options.name, project);
    if (options.unitTestRunner === "none" /* None */) {
        host.delete(`${options.appProjectRoot}/src/app/app.component.spec.ts`);
        host.delete(`${options.appProjectRoot}/tsconfig.spec.json`);
    }
    if (options.e2eTestRunner === "none" /* None */) {
        const projects = (0, devkit_1.getProjects)(host);
        if (projects.has(options.e2eProjectName)) {
            (0, devkit_1.removeProjectConfiguration)(host, options.e2eProjectName);
        }
    }
    // delete some default test configs
    host.delete(`${options.appProjectRoot}/karma.conf.js`);
    host.delete(`${options.appProjectRoot}/src/test.ts`);
}
//# sourceMappingURL=update-config-files.js.map