"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateComponentSpec = void 0;
const ts = require("typescript");
const ast_utils_1 = require("@nrwl/workspace/src/utilities/ast-utils");
const ast_utils_2 = require("../../../utils/nx-devkit/ast-utils");
function updateComponentSpec(host, options) {
    if (options.skipTests !== true) {
        const componentSpecPath = `${options.appProjectRoot}/src/app/app.component.spec.ts`;
        const componentSpecSource = host.read(componentSpecPath, 'utf-8');
        let componentSpecSourceFile = ts.createSourceFile(componentSpecPath, componentSpecSource, ts.ScriptTarget.Latest, true);
        host.write(componentSpecPath, componentSpecSource
            .replace('.content span', 'h1')
            .replace(`${options.name} app is running!`, `Welcome ${options.name}`));
        // Adding NxWelcome component to app.component.spec
        componentSpecSourceFile = (0, ast_utils_1.insertImport)(host, componentSpecSourceFile, componentSpecPath, 'NxWelcomeComponent', './nx-welcome.component');
        componentSpecSourceFile = (0, ast_utils_2.replaceIntoToTestBed)(host, componentSpecSourceFile, componentSpecPath, `declarations: [AppComponent, NxWelcomeComponent]`, `
      declarations: [
        AppComponent
      ],
    `);
        if (options.routing) {
            componentSpecSourceFile = (0, ast_utils_1.insertImport)(host, componentSpecSourceFile, componentSpecPath, 'RouterTestingModule', '@angular/router/testing');
            componentSpecSourceFile = (0, ast_utils_2.addImportToTestBed)(host, componentSpecSourceFile, componentSpecPath, `RouterTestingModule`);
        }
    }
}
exports.updateComponentSpec = updateComponentSpec;
//# sourceMappingURL=update-component-spec.js.map