"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateAppComponentTemplate = void 0;
const ts = require("typescript");
const ast_utils_1 = require("@nrwl/workspace/src/utilities/ast-utils");
const ast_utils_2 = require("../../../utils/nx-devkit/ast-utils");
const nrwl_home_tpl_1 = require("./nrwl-home-tpl");
function updateAppComponentTemplate(host, options) {
    const content = options.routing
        ? `${nrwl_home_tpl_1.nrwlHomeTemplate.getSelector(options.prefix)}\n<router-outlet></router-outlet>`
        : nrwl_home_tpl_1.nrwlHomeTemplate.getSelector(options.prefix);
    if (!options.inlineTemplate) {
        host.write(`${options.appProjectRoot}/src/app/app.component.html`, content);
        return;
    }
    // Inline component update
    const componentPath = `${options.appProjectRoot}/src/app/app.component.ts`;
    const templateNodeValue = (0, ast_utils_2.getDecoratorPropertyValueNode)(host, componentPath, 'Component', 'template', '@angular/core');
    (0, ast_utils_1.replaceNodeValue)(host, ts.createSourceFile(componentPath, host.read(componentPath, 'utf-8'), ts.ScriptTarget.Latest, true), componentPath, templateNodeValue, `\`\n${nrwl_home_tpl_1.nrwlHomeTemplate.getSelector(options.prefix)}\n\``);
}
exports.updateAppComponentTemplate = updateAppComponentTemplate;
//# sourceMappingURL=update-app-component-template.js.map