"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addRouterRootConfiguration = void 0;
const ast_utils_1 = require("@nrwl/workspace/src/utilities/ast-utils");
const ts = require("typescript");
const ast_utils_2 = require("../../../utils/nx-devkit/ast-utils");
function addRouterRootConfiguration(host, options) {
    const modulePath = `${options.appProjectRoot}/src/app/app.module.ts`;
    const moduleSource = host.read(modulePath, 'utf-8');
    let sourceFile = ts.createSourceFile(modulePath, moduleSource, ts.ScriptTarget.Latest, true);
    sourceFile = (0, ast_utils_1.insertImport)(host, sourceFile, modulePath, 'RouterModule', '@angular/router');
    sourceFile = (0, ast_utils_2.addImportToModule)(host, sourceFile, modulePath, `RouterModule.forRoot([], {initialNavigation: 'enabledBlocking'})`);
}
exports.addRouterRootConfiguration = addRouterRootConfiguration;
//# sourceMappingURL=root-router-config.js.map