"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.removeScaffoldedE2e = void 0;
const devkit_1 = require("@nrwl/devkit");
function removeScaffoldedE2e(host, { name }, e2eProjectRoot) {
    if (host.exists(`${e2eProjectRoot}/src/app.e2e-spec.ts`)) {
        host.delete(`${e2eProjectRoot}/src/app.e2e-spec.ts`);
    }
    if (host.exists(`${e2eProjectRoot}/src/app.po.ts`)) {
        host.delete(`${e2eProjectRoot}/src/app.po.ts`);
    }
    if (host.exists(`${e2eProjectRoot}/protractor.conf.js`)) {
        host.delete(`${e2eProjectRoot}/protractor.conf.js`);
    }
    if (host.exists(`${e2eProjectRoot}/tsconfig.json`)) {
        host.delete(`${e2eProjectRoot}/tsconfig.json`);
    }
    const project = (0, devkit_1.readProjectConfiguration)(host, name);
    delete project.targets['e2e'];
    (0, devkit_1.updateProjectConfiguration)(host, name, project);
}
exports.removeScaffoldedE2e = removeScaffoldedE2e;
//# sourceMappingURL=remove-scaffolded-e2e.js.map