"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.normalizeOptions = void 0;
const devkit_1 = require("@nrwl/devkit");
const devkit_2 = require("@nrwl/devkit");
const linter_1 = require("@nrwl/linter");
function normalizeOptions(host, options) {
    var _a, _b;
    const { appsDir, npmScope, standaloneAsDefault } = (0, devkit_2.getWorkspaceLayout)(host);
    const appDirectory = options.directory
        ? `${(0, devkit_2.names)(options.directory).fileName}/${(0, devkit_2.names)(options.name).fileName}`
        : (0, devkit_2.names)(options.name).fileName;
    let e2eProjectName = `${(0, devkit_2.names)(options.name).fileName}-e2e`;
    const appProjectName = appDirectory
        .replace(new RegExp('/', 'g'), '-')
        .replace(/-\d+/g, '');
    if (options.e2eTestRunner !== 'cypress') {
        e2eProjectName = `${appProjectName}-e2e`;
    }
    const appProjectRoot = (0, devkit_1.joinPathFragments)(appsDir, appDirectory);
    const e2eProjectRoot = (0, devkit_1.joinPathFragments)(appsDir, `${appDirectory}-e2e`);
    const parsedTags = options.tags
        ? options.tags.split(',').map((s) => s.trim())
        : [];
    const defaultPrefix = npmScope;
    options.standaloneConfig = (_a = options.standaloneConfig) !== null && _a !== void 0 ? _a : standaloneAsDefault;
    // Determine the roots where @schematics/angular will place the projects
    // This might not be where the projects actually end up
    const workspaceJsonPath = (0, devkit_1.getWorkspacePath)(host);
    let newProjectRoot = null;
    if (workspaceJsonPath) {
        ({ newProjectRoot } = (0, devkit_1.readJson)(host, workspaceJsonPath));
    }
    const ngCliSchematicAppRoot = newProjectRoot
        ? `${newProjectRoot}/${appProjectName}`
        : appProjectName;
    const ngCliSchematicE2ERoot = newProjectRoot
        ? `${newProjectRoot}/${e2eProjectName}`
        : `${appProjectName}/e2e`;
    // Set defaults and then overwrite with user options
    return Object.assign(Object.assign({ style: 'css', routing: false, inlineStyle: false, inlineTemplate: false, skipTests: false, skipFormat: false, unitTestRunner: "jest" /* Jest */, e2eTestRunner: "cypress" /* Cypress */, linter: linter_1.Linter.EsLint, strict: true }, options), { prefix: (_b = options.prefix) !== null && _b !== void 0 ? _b : defaultPrefix, name: appProjectName, appProjectRoot,
        e2eProjectRoot,
        e2eProjectName,
        parsedTags,
        ngCliSchematicAppRoot,
        ngCliSchematicE2ERoot });
}
exports.normalizeOptions = normalizeOptions;
//# sourceMappingURL=normalize-options.js.map