"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.enableStrictTypeChecking = void 0;
const devkit_1 = require("@nrwl/devkit");
function enableStrictTypeChecking(host, options) {
    const configFiles = [
        `${options.appProjectRoot}/tsconfig.json`,
        `${options.e2eProjectRoot}/tsconfig.json`,
    ];
    for (const configFile of configFiles) {
        if (!host.exists(configFile)) {
            continue;
        }
        // Update the settings in the tsconfig.app.json to enable strict type checking.
        // This matches the settings defined by the Angular CLI https://angular.io/guide/strict-mode
        (0, devkit_1.updateJson)(host, configFile, (json) => {
            var _a, _b;
            // update the TypeScript settings
            json.compilerOptions = Object.assign(Object.assign({}, ((_a = json.compilerOptions) !== null && _a !== void 0 ? _a : {})), { forceConsistentCasingInFileNames: true, strict: true, noImplicitOverride: true, noPropertyAccessFromIndexSignature: true, noImplicitReturns: true, noFallthroughCasesInSwitch: true });
            // update Angular Template Settings
            json.angularCompilerOptions = Object.assign(Object.assign({}, ((_b = json.angularCompilerOptions) !== null && _b !== void 0 ? _b : {})), { strictInjectionParameters: true, strictInputAccessModifiers: true, strictTemplates: true });
            return json;
        });
    }
}
exports.enableStrictTypeChecking = enableStrictTypeChecking;
//# sourceMappingURL=enable-strict-type-checking.js.map