"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addUnitTestRunner = void 0;
const tslib_1 = require("tslib");
const jest_1 = require("@nrwl/jest");
const karma_project_1 = require("../../karma-project/karma-project");
function addUnitTestRunner(host, options) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        if (options.unitTestRunner === "jest" /* Jest */) {
            yield (0, jest_1.jestProjectGenerator)(host, {
                project: options.name,
                setupFile: 'angular',
                supportTsx: false,
                skipSerializers: false,
                skipPackageJson: options.skipPackageJson,
            });
        }
        else if (options.unitTestRunner === "karma" /* Karma */) {
            yield (0, karma_project_1.default)(host, {
                project: options.name,
                skipFormat: true,
            });
        }
    });
}
exports.addUnitTestRunner = addUnitTestRunner;
//# sourceMappingURL=add-unit-test-runner.js.map