"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addLinting = void 0;
const tslib_1 = require("tslib");
const linter_1 = require("@nrwl/linter");
const add_linting_1 = require("../../add-linting/add-linting");
function addLinting(host, options) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        if (options.linter === linter_1.Linter.None) {
            return;
        }
        yield (0, add_linting_1.default)(host, {
            projectName: options.name,
            projectRoot: options.appProjectRoot,
            prefix: options.prefix,
            setParserOptionsProject: options.setParserOptionsProject,
            skipPackageJson: options.skipPackageJson,
        });
    });
}
exports.addLinting = addLinting;
//# sourceMappingURL=add-linting.js.map