"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addE2e = void 0;
const tslib_1 = require("tslib");
const cypress_1 = require("@nrwl/cypress");
const add_protractor_1 = require("./add-protractor");
const remove_scaffolded_e2e_1 = require("./remove-scaffolded-e2e");
const update_e2e_project_1 = require("./update-e2e-project");
const generators_1 = require("@nrwl/workspace/generators");
const linter_1 = require("@nrwl/linter");
const devkit_1 = require("@nrwl/devkit");
function addE2e(tree, options) {
    var _a;
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        if (options.e2eTestRunner === "protractor" /* Protractor */) {
            yield (0, add_protractor_1.addProtractor)(tree, options);
        }
        else {
            (0, remove_scaffolded_e2e_1.removeScaffoldedE2e)(tree, options, options.ngCliSchematicE2ERoot);
        }
        if (options.e2eTestRunner === 'cypress') {
            yield (0, cypress_1.cypressProjectGenerator)(tree, {
                name: options.e2eProjectName,
                directory: options.directory,
                project: options.name,
                linter: options.linter,
                skipFormat: options.skipFormat,
                standaloneConfig: options.standaloneConfig,
                skipPackageJson: options.skipPackageJson,
            });
        }
        if (options.e2eTestRunner === "protractor" /* Protractor */) {
            (0, update_e2e_project_1.updateE2eProject)(tree, options);
            if ((_a = options.standaloneConfig) !== null && _a !== void 0 ? _a : (0, devkit_1.getWorkspaceLayout)(tree).standaloneAsDefault) {
                yield (0, generators_1.convertToNxProjectGenerator)(tree, {
                    project: `${options.e2eProjectName}`,
                });
            }
            if (options.linter === linter_1.Linter.EsLint) {
                yield (0, linter_1.lintProjectGenerator)(tree, {
                    project: options.e2eProjectName,
                    linter: options.linter,
                    eslintFilePatterns: [
                        (0, devkit_1.joinPathFragments)(options.e2eProjectRoot, '**/*.ts'),
                    ],
                    skipFormat: true,
                    setParserOptionsProject: options.setParserOptionsProject,
                    skipPackageJson: options.skipPackageJson,
                });
            }
        }
    });
}
exports.addE2e = addE2e;
//# sourceMappingURL=add-e2e.js.map