"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.applicationGenerator = void 0;
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const ngcli_adapter_1 = require("@nrwl/devkit/ngcli-adapter");
const generators_1 = require("@nrwl/workspace/generators");
const init_1 = require("../init/init");
const setup_tailwind_1 = require("../setup-tailwind/setup-tailwind");
const lib_1 = require("./lib");
function applicationGenerator(host, schema) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const options = (0, lib_1.normalizeOptions)(host, schema);
        yield (0, init_1.angularInitGenerator)(host, Object.assign(Object.assign({}, options), { skipFormat: true }));
        const angularAppSchematic = (0, ngcli_adapter_1.wrapAngularDevkitSchematic)('@schematics/angular', 'application');
        yield angularAppSchematic(host, {
            name: options.name,
            inlineStyle: options.inlineStyle,
            inlineTemplate: options.inlineTemplate,
            prefix: options.prefix,
            skipTests: options.skipTests,
            style: options.style,
            viewEncapsulation: options.viewEncapsulation,
            routing: false,
            skipInstall: true,
            skipPackageJson: options.skipPackageJson,
        });
        if (options.ngCliSchematicAppRoot !== options.appProjectRoot) {
            (0, devkit_1.moveFilesToNewDirectory)(host, options.ngCliSchematicAppRoot, options.appProjectRoot);
        }
        (0, lib_1.createFiles)(host, options);
        (0, lib_1.updateConfigFiles)(host, options);
        (0, lib_1.updateAppComponentTemplate)(host, options);
        // Create the NxWelcomeComponent
        const angularComponentSchematic = (0, ngcli_adapter_1.wrapAngularDevkitSchematic)('@schematics/angular', 'component');
        yield angularComponentSchematic(host, {
            name: 'NxWelcome',
            inlineTemplate: true,
            inlineStyle: true,
            prefix: options.prefix,
            skipTests: true,
            style: options.style,
            flat: true,
            viewEncapsulation: 'None',
            project: options.name,
        });
        (0, lib_1.updateNxComponentTemplate)(host, options);
        if (options.addTailwind) {
            yield (0, setup_tailwind_1.setupTailwindGenerator)(host, {
                project: options.name,
                skipFormat: true,
                skipPackageJson: options.skipPackageJson,
            });
        }
        if (options.unitTestRunner !== "none" /* None */) {
            (0, lib_1.updateComponentSpec)(host, options);
        }
        if (options.routing) {
            (0, lib_1.addRouterRootConfiguration)(host, options);
        }
        (0, lib_1.addLinting)(host, options);
        yield (0, lib_1.addUnitTestRunner)(host, options);
        yield (0, lib_1.addE2e)(host, options);
        (0, lib_1.updateEditorTsConfig)(host, options);
        if (options.backendProject) {
            (0, lib_1.addProxyConfig)(host, options);
        }
        if (options.strict) {
            (0, lib_1.enableStrictTypeChecking)(host, options);
        }
        else {
            (0, lib_1.setApplicationStrictDefault)(host, false);
        }
        if (options.standaloneConfig) {
            yield (0, generators_1.convertToNxProjectGenerator)(host, {
                project: options.name,
                all: false,
            });
        }
        if (options.mfe) {
            yield (0, lib_1.addMfe)(host, options);
        }
        if (!options.skipFormat) {
            yield (0, devkit_1.formatFiles)(host);
        }
        return () => {
            (0, devkit_1.installPackagesTask)(host);
        };
    });
}
exports.applicationGenerator = applicationGenerator;
exports.default = applicationGenerator;
//# sourceMappingURL=application.js.map