"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createEsLintConfiguration = void 0;
const devkit_1 = require("@nrwl/devkit");
const strings_1 = require("@nrwl/workspace/src/utils/strings");
function createEsLintConfiguration(tree, options) {
    const rootConfig = `${(0, devkit_1.offsetFromRoot)(options.projectRoot)}.eslintrc.json`;
    // Include all project files to be linted (since they are turned off in the root eslintrc file).
    const ignorePatterns = ['!**/*'];
    const configJson = {
        extends: [rootConfig],
        ignorePatterns,
        overrides: [
            {
                files: ['*.ts'],
                extends: [
                    'plugin:@nrwl/nx/angular',
                    'plugin:@angular-eslint/template/process-inline-templates',
                ],
                /**
                 * NOTE: We no longer set parserOptions.project by default when creating new projects.
                 *
                 * We have observed that users rarely add rules requiring type-checking to their Nx workspaces, and therefore
                 * do not actually need the capabilites which parserOptions.project provides. When specifying parserOptions.project,
                 * typescript-eslint needs to create full TypeScript Programs for you. When omitting it, it can perform a simple
                 * parse (and AST tranformation) of the source files it encounters during a lint run, which is much faster and much
                 * less memory intensive.
                 *
                 * In the rare case that users attempt to add rules requiring type-checking to their setup later on (and haven't set
                 * parserOptions.project), the executor will attempt to look for the particular error typescript-eslint gives you
                 * and provide feedback to the user.
                 */
                parserOptions: !options.setParserOptionsProject
                    ? undefined
                    : {
                        project: [`${options.projectRoot}/tsconfig.*?.json`],
                    },
                rules: {
                    '@angular-eslint/directive-selector': [
                        'error',
                        {
                            type: 'attribute',
                            prefix: (0, strings_1.camelize)(options.prefix),
                            style: 'camelCase',
                        },
                    ],
                    '@angular-eslint/component-selector': [
                        'error',
                        {
                            type: 'element',
                            prefix: (0, strings_1.dasherize)(options.prefix),
                            style: 'kebab-case',
                        },
                    ],
                },
            },
            {
                files: ['*.html'],
                extends: ['plugin:@nrwl/nx/angular-template'],
                /**
                 * Having an empty rules object present makes it more obvious to the user where they would
                 * extend things from if they needed to
                 */
                rules: {},
            },
        ],
    };
    (0, devkit_1.writeJson)(tree, (0, devkit_1.joinPathFragments)(options.projectRoot, '.eslintrc.json'), configJson);
}
exports.createEsLintConfiguration = createEsLintConfiguration;
//# sourceMappingURL=create-eslint-configuration.js.map