"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addProjectLintTarget = void 0;
const devkit_1 = require("@nrwl/devkit");
function addProjectLintTarget(tree, options) {
    const project = (0, devkit_1.readProjectConfiguration)(tree, options.projectName);
    project.targets.lint = {
        executor: '@nrwl/linter:eslint',
        options: {
            lintFilePatterns: [
                `${options.projectRoot}/src/**/*.ts`,
                `${options.projectRoot}/src/**/*.html`,
            ],
        },
    };
    (0, devkit_1.updateProjectConfiguration)(tree, options.projectName, project);
}
exports.addProjectLintTarget = addProjectLintTarget;
//# sourceMappingURL=add-project-lint-target.js.map