"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addLintingGenerator = void 0;
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const linter_1 = require("@nrwl/linter");
const add_angular_eslint_dependencies_1 = require("./lib/add-angular-eslint-dependencies");
const add_project_lint_target_1 = require("./lib/add-project-lint-target");
const create_eslint_configuration_1 = require("./lib/create-eslint-configuration");
function addLintingGenerator(tree, options) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const installTask = (0, linter_1.lintInitGenerator)(tree, {
            linter: linter_1.Linter.EsLint,
            skipPackageJson: options.skipPackageJson,
        });
        if (!options.skipPackageJson) {
            (0, add_angular_eslint_dependencies_1.addAngularEsLintDependencies)(tree);
        }
        (0, create_eslint_configuration_1.createEsLintConfiguration)(tree, options);
        (0, add_project_lint_target_1.addProjectLintTarget)(tree, options);
        if (!options.skipFormat) {
            yield (0, devkit_1.formatFiles)(tree);
        }
        return installTask;
    });
}
exports.addLintingGenerator = addLintingGenerator;
exports.default = addLintingGenerator;
//# sourceMappingURL=add-linting.js.map