"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTailwindPostCssPlugins = exports.getTailwindSetup = exports.tailwindDirectives = void 0;
const devkit_1 = require("@nrwl/devkit");
const devkit_2 = require("@nrwl/devkit");
const fs_1 = require("fs");
const path_1 = require("path");
const postcssImport = require("postcss-import");
exports.tailwindDirectives = [
    '@tailwind',
    '@apply',
    '@layer',
    '@variants',
    '@responsive',
    '@screen',
];
function getTailwindSetup(basePath, tailwindConfig) {
    let tailwindConfigPath = tailwindConfig;
    if (!tailwindConfigPath) {
        // Try to find TailwindCSS configuration file in the project or workspace root.
        const tailwindConfigFile = 'tailwind.config.js';
        for (const path of [basePath, devkit_2.workspaceRoot]) {
            const fullPath = (0, path_1.join)(path, tailwindConfigFile);
            if ((0, fs_1.existsSync)(fullPath)) {
                tailwindConfigPath = fullPath;
                break;
            }
        }
    }
    // Only load Tailwind CSS plugin if configuration file was found.
    if (!tailwindConfigPath) {
        return undefined;
    }
    let tailwindPackagePath;
    try {
        tailwindPackagePath = require.resolve('tailwindcss');
    }
    catch (_a) {
        const relativeTailwindConfigPath = (0, path_1.relative)(devkit_2.workspaceRoot, tailwindConfigPath);
        devkit_1.logger.warn(`Tailwind CSS configuration file found (${relativeTailwindConfigPath})` +
            ` but the 'tailwindcss' package is not installed.` +
            ` To enable Tailwind CSS, please install the 'tailwindcss' package.`);
        return undefined;
    }
    if (!tailwindPackagePath) {
        return undefined;
    }
    return { tailwindConfigPath, tailwindPackagePath };
}
exports.getTailwindSetup = getTailwindSetup;
function getTailwindPostCssPlugins({ tailwindConfigPath, tailwindPackagePath }, includePaths, watch) {
    if (process.env['TAILWIND_MODE'] === undefined) {
        process.env['TAILWIND_MODE'] = watch ? 'watch' : 'build';
    }
    return [
        postcssImport({
            addModulesDirectories: includePaths !== null && includePaths !== void 0 ? includePaths : [],
            resolve: (url) => (url.startsWith('~') ? url.substring(1) : url),
        }),
        require(tailwindPackagePath)({ config: tailwindConfigPath }),
    ];
}
exports.getTailwindPostCssPlugins = getTailwindPostCssPlugins;
//# sourceMappingURL=tailwindcss.js.map