"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.packageExecutor = exports.createLibraryExecutor = void 0;
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const buildable_libs_utils_1 = require("@nrwl/workspace/src/utilities/buildable-libs-utils");
const path_1 = require("path");
const rxjs_1 = require("rxjs");
const rxjs_for_await_1 = require("rxjs-for-await");
const operators_1 = require("rxjs/operators");
const entry_point_di_1 = require("./ng-packagr-adjustments/ng-package/entry-point/entry-point.di");
const options_di_1 = require("./ng-packagr-adjustments/ng-package/options.di");
const package_di_1 = require("./ng-packagr-adjustments/ng-package/package.di");
function initializeNgPackagr(options, context, projectDependencies) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const packager = new (yield Promise.resolve().then(() => require('ng-packagr'))).NgPackagr([
            ...package_di_1.NX_PACKAGE_PROVIDERS,
            ...entry_point_di_1.NX_ENTRY_POINT_PROVIDERS,
            (0, options_di_1.nxProvideOptions)({
                tailwindConfig: options.tailwindConfig,
                watch: options.watch,
            }),
        ]);
        packager.forProject((0, path_1.resolve)(context.root, options.project));
        packager.withBuildTransform(package_di_1.NX_PACKAGE_TRANSFORM.provide);
        if (options.tsConfig) {
            const tsConfigPath = (0, buildable_libs_utils_1.createTmpTsConfig)(options.tsConfig, context.root, context.workspace.projects[context.projectName].root, projectDependencies);
            packager.withTsConfig(tsConfigPath);
        }
        return packager;
    });
}
/**
 * Creates an executor function that executes the library build of an Angular
 * package using ng-packagr.
 * @param initializeNgPackagr function that returns an ngPackagr instance to use for the build.
 */
function createLibraryExecutor(initializeNgPackagr) {
    return function (options, context) {
        return tslib_1.__asyncGenerator(this, arguments, function* () {
            const { target, dependencies, topLevelDependencies } = (0, buildable_libs_utils_1.calculateProjectDependencies)((0, devkit_1.readCachedProjectGraph)(), context.root, context.projectName, context.targetName, context.configurationName);
            if (!(0, buildable_libs_utils_1.checkDependentProjectsHaveBeenBuilt)(context.root, context.projectName, context.targetName, dependencies)) {
                return yield tslib_1.__await(Promise.resolve({ success: false }));
            }
            function updatePackageJson() {
                if (topLevelDependencies.length > 0 &&
                    options.updateBuildableProjectDepsInPackageJson) {
                    (0, buildable_libs_utils_1.updateBuildableProjectPackageJsonDependencies)(context.root, context.projectName, context.targetName, context.configurationName, target, topLevelDependencies, options.buildableProjectDepsInPackageJsonType);
                }
            }
            if (options.watch) {
                return yield tslib_1.__await(yield tslib_1.__await(yield* tslib_1.__asyncDelegator(tslib_1.__asyncValues((0, rxjs_for_await_1.eachValueFrom)((0, rxjs_1.from)(initializeNgPackagr(options, context, dependencies)).pipe((0, operators_1.switchMap)((packagr) => packagr.watch()), (0, operators_1.tap)(() => updatePackageJson()), (0, operators_1.mapTo)({ success: true })))))));
            }
            return yield tslib_1.__await((0, rxjs_1.from)(initializeNgPackagr(options, context, dependencies))
                .pipe((0, operators_1.switchMap)((packagr) => packagr.build()), (0, operators_1.tap)(() => updatePackageJson()), (0, operators_1.mapTo)({ success: true }))
                .toPromise());
        });
    };
}
exports.createLibraryExecutor = createLibraryExecutor;
exports.packageExecutor = createLibraryExecutor(initializeNgPackagr);
exports.default = exports.packageExecutor;
//# sourceMappingURL=package.impl.js.map