/**
 * Adapted from the original ng-packagr source.
 *
 * Changes made:
 * - Changed filePath passed to the StylesheetProcessor.parse when is a .ts file and inlineStyleLanguage is set.
 */
import type { CompilerHost, CompilerOptions } from '@angular/compiler-cli';
import { FileCache } from 'ng-packagr/lib/file-system/file-cache';
import { BuildGraph } from 'ng-packagr/lib/graph/build-graph';
import { EntryPointNode } from 'ng-packagr/lib/ng-package/nodes';
import * as ts from 'typescript';
import { InlineStyleLanguage, StylesheetProcessor } from '../styles/stylesheet-processor';
export declare function cacheCompilerHost(graph: BuildGraph, entryPoint: EntryPointNode, compilerOptions: CompilerOptions, moduleResolutionCache: ts.ModuleResolutionCache, stylesheetProcessor?: StylesheetProcessor, inlineStyleLanguage?: InlineStyleLanguage, sourcesFileCache?: FileCache): CompilerHost;
export declare function augmentProgramWithVersioning(program: ts.Program): void;
