"use strict";
/**
 * Adapted from the original ng-packagr.
 *
 * Changes made:
 * - Use our own options interface to add support for tailwindConfig.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.NX_DEFAULT_OPTIONS_PROVIDER = exports.nxProvideOptions = exports.NX_OPTIONS_TOKEN = void 0;
const findCacheDirectory = require("find-cache-dir");
const injection_js_1 = require("injection-js");
const os_1 = require("os");
const path_1 = require("path");
exports.NX_OPTIONS_TOKEN = new injection_js_1.InjectionToken(`nx.v1.options`);
const nxProvideOptions = (options = {}) => ({
    provide: exports.NX_OPTIONS_TOKEN,
    useValue: normalizeOptions(options),
});
exports.nxProvideOptions = nxProvideOptions;
exports.NX_DEFAULT_OPTIONS_PROVIDER = (0, exports.nxProvideOptions)();
function normalizeOptions(options = {}) {
    const ciEnv = process.env['CI'];
    const isCI = (ciEnv === null || ciEnv === void 0 ? void 0 : ciEnv.toLowerCase()) === 'true' || ciEnv === '1';
    const { cacheEnabled = !isCI, cacheDirectory = findCachePath() } = options;
    return Object.assign(Object.assign({}, options), { cacheEnabled,
        cacheDirectory });
}
function findCachePath() {
    const name = 'ng-packagr';
    return findCacheDirectory({ name }) || (0, path_1.resolve)((0, os_1.tmpdir)(), name);
}
//# sourceMappingURL=options.di.js.map