"use strict";
/**
 * Adapted from the original ng-packagr source.
 *
 * Changes made:
 * - Use NX_COMPILE_NGC_TOKEN instead of COMPILE_NGC_TOKEN.
 * - Use NX_COMPILE_NGC_PROVIDERS instead of COMPILE_NGC_PROVIDERS.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.NX_ENTRY_POINT_PROVIDERS = exports.NX_ENTRY_POINT_TRANSFORM = exports.NX_ENTRY_POINT_TRANSFORM_TOKEN = void 0;
const injection_js_1 = require("injection-js");
const transform_di_1 = require("ng-packagr/lib/graph/transform.di");
const entry_point_transform_1 = require("ng-packagr/lib/ng-package/entry-point/entry-point.transform");
const write_bundles_di_1 = require("ng-packagr/lib/ng-package/entry-point/write-bundles.di");
const write_package_di_1 = require("ng-packagr/lib/ng-package/entry-point/write-package.di");
const compile_ngc_di_1 = require("./compile-ngc.di");
exports.NX_ENTRY_POINT_TRANSFORM_TOKEN = new injection_js_1.InjectionToken(`nx.v1.entryPointTransform`);
exports.NX_ENTRY_POINT_TRANSFORM = (0, transform_di_1.provideTransform)({
    provide: exports.NX_ENTRY_POINT_TRANSFORM_TOKEN,
    useFactory: entry_point_transform_1.entryPointTransformFactory,
    deps: [
        compile_ngc_di_1.NX_COMPILE_NGC_TOKEN,
        write_bundles_di_1.WRITE_BUNDLES_TRANSFORM_TOKEN,
        write_package_di_1.WRITE_PACKAGE_TRANSFORM_TOKEN,
    ],
});
exports.NX_ENTRY_POINT_PROVIDERS = [
    exports.NX_ENTRY_POINT_TRANSFORM,
    ...compile_ngc_di_1.NX_COMPILE_NGC_PROVIDERS,
    write_bundles_di_1.WRITE_BUNDLES_TRANSFORM,
    write_package_di_1.WRITE_PACKAGE_TRANSFORM,
];
//# sourceMappingURL=entry-point.di.js.map