"use strict";
/**
 * Adapted from the original ng-packagr source.
 *
 * Changes made:
 * - Use our own StylesheetProcessor files instead of the ones provide by ng-packagr.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.compileNgcTransformFactory = void 0;
const tslib_1 = require("tslib");
const transform_1 = require("ng-packagr/lib/graph/transform");
const nodes_1 = require("ng-packagr/lib/ng-package/nodes");
const ngcc_processor_1 = require("ng-packagr/lib/ngc/ngcc-processor");
const tsconfig_1 = require("ng-packagr/lib/ts/tsconfig");
const ng_compiler_cli_1 = require("ng-packagr/lib/utils/ng-compiler-cli");
const ora = require("ora");
const path = require("path");
const ts = require("typescript");
const compile_source_files_1 = require("../../ngc/compile-source-files");
const compileNgcTransformFactory = (StylesheetProcessor, options) => {
    return (0, transform_1.transformFromPromise)((graph) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
        var _a;
        var _b;
        const spinner = ora({
            hideCursor: false,
            discardStdin: false,
        });
        try {
            const entryPoint = graph.find((0, nodes_1.isEntryPointInProgress)());
            const entryPoints = graph.filter(nodes_1.isEntryPoint);
            // Add paths mappings for dependencies
            const tsConfig = (0, tsconfig_1.setDependenciesTsConfigPaths)(entryPoint.data.tsConfig, entryPoints);
            // Compile TypeScript sources
            const { esm2020, declarations } = entryPoint.data.destinationFiles;
            const { basePath, cssUrl, styleIncludePaths } = entryPoint.data.entryPoint;
            const { moduleResolutionCache, ngccProcessingCache } = entryPoint.cache;
            spinner.start(`Compiling with Angular sources in Ivy ${tsConfig.options.compilationMode || 'full'} compilation mode.`);
            const ngccProcessor = new ngcc_processor_1.NgccProcessor(yield (0, ng_compiler_cli_1.ngccCompilerCli)(), ngccProcessingCache, tsConfig.project, tsConfig.options, entryPoints);
            if (!entryPoint.data.entryPoint.isSecondaryEntryPoint) {
                // Only run the async version of NGCC during the primary entrypoint processing.
                yield ngccProcessor.process();
            }
            (_a = (_b = entryPoint.cache).stylesheetProcessor) !== null && _a !== void 0 ? _a : (_b.stylesheetProcessor = new StylesheetProcessor(basePath, cssUrl, styleIncludePaths, options.cacheEnabled && options.cacheDirectory, options.watch, options.tailwindConfig));
            yield (0, compile_source_files_1.compileSourceFiles)(graph, tsConfig, moduleResolutionCache, {
                outDir: path.dirname(esm2020),
                declarationDir: path.dirname(declarations),
                declaration: true,
                target: ts.ScriptTarget.ES2020,
            }, entryPoint.cache.stylesheetProcessor, ngccProcessor, options.watch);
        }
        catch (error) {
            spinner.fail();
            throw error;
        }
        spinner.succeed();
        return graph;
    }));
};
exports.compileNgcTransformFactory = compileNgcTransformFactory;
//# sourceMappingURL=compile-ngc.transform.js.map