"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ngPackagrLiteExecutor = void 0;
const tslib_1 = require("tslib");
const buildable_libs_utils_1 = require("@nrwl/workspace/src/utilities/buildable-libs-utils");
const ng_packagr_1 = require("ng-packagr");
const path_1 = require("path");
const package_impl_1 = require("../package/package.impl");
const entry_point_di_1 = require("./ng-packagr-adjustments/ng-package/entry-point/entry-point.di");
const options_di_1 = require("./ng-packagr-adjustments/ng-package/options.di");
const package_di_1 = require("./ng-packagr-adjustments/ng-package/package.di");
function initializeNgPackgrLite(options, context, projectDependencies) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const packager = new ng_packagr_1.NgPackagr([
            // Add default providers to this list.
            ...package_di_1.NX_PACKAGE_PROVIDERS,
            ...entry_point_di_1.NX_ENTRY_POINT_PROVIDERS,
            (0, options_di_1.nxProvideOptions)({
                tailwindConfig: options.tailwindConfig,
                watch: options.watch,
            }),
        ]);
        packager.forProject((0, path_1.resolve)(context.root, options.project));
        packager.withBuildTransform(package_di_1.NX_PACKAGE_TRANSFORM.provide);
        if (options.tsConfig) {
            const tsConfigPath = (0, buildable_libs_utils_1.createTmpTsConfig)(options.tsConfig, context.root, context.workspace.projects[context.projectName].root, projectDependencies);
            packager.withTsConfig(tsConfigPath);
        }
        return packager;
    });
}
exports.ngPackagrLiteExecutor = (0, package_impl_1.createLibraryExecutor)(initializeNgPackgrLite);
exports.default = exports.ngPackagrLiteExecutor;
//# sourceMappingURL=ng-packagr-lite.impl.js.map