/**
 * Adapted from the original ng-packagr source.
 *
 * Changes made:
 * - Added the filePath parameter to the cache key.
 * - Refactored caching to take into account TailwindCSS processing.
 * - Added PostCSS plugins needed to support TailwindCSS.
 * - Added watch mode parameter.
 */
export declare enum CssUrl {
    inline = "inline",
    none = "none"
}
export declare enum InlineStyleLanguage {
    sass = "sass",
    scss = "scss",
    css = "css",
    less = "less"
}
export interface Result {
    css: string;
    warnings: string[];
    error?: string;
}
export declare class StylesheetProcessor {
    private readonly basePath;
    private readonly cssUrl?;
    private readonly includePaths?;
    private readonly cacheDirectory?;
    private readonly watch?;
    private readonly tailwindConfig?;
    private browserslistData;
    private targets;
    private postCssProcessor;
    private esbuild;
    private styleIncludePaths;
    private tailwindSetup;
    constructor(basePath: string, cssUrl?: CssUrl, includePaths?: string[], cacheDirectory?: string | false, watch?: boolean, tailwindConfig?: string);
    process({ filePath, content, }: {
        filePath: string;
        content: string;
    }): Promise<string>;
    private getCachedResult;
    private containsTailwindDirectives;
    private createPostCssPlugins;
    private renderCss;
}
