"use strict";
/**
 * Adapted from the original ng-packagr.
 *
 * Changes made:
 * - Use NX_ENTRY_POINT_TRANSFORM_TOKEN instead of ENTRY_POINT_TRANSFORM_TOKEN.
 * - USE NX_OPTIONS_TOKEN instead of OPTIONS_TOKEN.
 * - USE NX_DEFAULT_OPTIONS_PROVIDER instead of DEFAULT_OPTIONS_PROVIDER.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.NX_PACKAGE_PROVIDERS = exports.NX_PACKAGE_TRANSFORM = exports.NX_PACKAGE_TRANSFORM_TOKEN = void 0;
const injection_js_1 = require("injection-js");
const transform_di_1 = require("ng-packagr/lib/graph/transform.di");
const analyse_sources_di_1 = require("ng-packagr/lib/ng-package/entry-point/analyse-sources.di");
const init_tsconfig_di_1 = require("ng-packagr/lib/ng-package/entry-point/init-tsconfig.di");
const package_transform_1 = require("ng-packagr/lib/ng-package/package.transform");
const project_di_1 = require("ng-packagr/lib/project.di");
const entry_point_di_1 = require("./entry-point/entry-point.di");
const options_di_1 = require("./options.di");
exports.NX_PACKAGE_TRANSFORM_TOKEN = new injection_js_1.InjectionToken(`nx.v1.packageTransform`);
exports.NX_PACKAGE_TRANSFORM = (0, transform_di_1.provideTransform)({
    provide: exports.NX_PACKAGE_TRANSFORM_TOKEN,
    useFactory: package_transform_1.packageTransformFactory,
    deps: [
        project_di_1.PROJECT_TOKEN,
        options_di_1.NX_OPTIONS_TOKEN,
        init_tsconfig_di_1.INIT_TS_CONFIG_TOKEN,
        analyse_sources_di_1.ANALYSE_SOURCES_TOKEN,
        entry_point_di_1.NX_ENTRY_POINT_TRANSFORM_TOKEN,
    ],
});
exports.NX_PACKAGE_PROVIDERS = [
    exports.NX_PACKAGE_TRANSFORM,
    options_di_1.NX_DEFAULT_OPTIONS_PROVIDER,
    init_tsconfig_di_1.INIT_TS_CONFIG_TRANSFORM,
    analyse_sources_di_1.ANALYSE_SOURCES_TRANSFORM,
];
//# sourceMappingURL=package.di.js.map