"use strict";
/**
 * Adapted from the original ng-packagr source.
 *
 * Changes made:
 * - Removed writing bundles as we don't generate them for incremental builds.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.nxEntryPointTransformFactory = void 0;
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const node_1 = require("ng-packagr/lib/graph/node");
const select_1 = require("ng-packagr/lib/graph/select");
const transform_1 = require("ng-packagr/lib/graph/transform");
const nodes_1 = require("ng-packagr/lib/ng-package/nodes");
const rxjs_1 = require("rxjs");
/**
 * A re-write of the `transformSources()` script that transforms an entry point from sources to distributable format.
 *
 * Sources are TypeScript source files accompanied by HTML templates and xCSS stylesheets.
 * See the Angular Package Format for a detailed description of what the distributables include.
 *
 * The current transformation pipeline can be thought of as:
 *
 *  - clean
 *  - compileTs
 *  - downlevelTs
 *  - relocateSourceMaps
 *  - writePackage
 *    - copyStagedFiles (esm, dts, sourcemaps)
 *    - writePackageJson
 *
 * The transformation pipeline is pluggable through the dependency injection system.
 * Sub-transformations are passed to this factory function as arguments.
 *
 * @param compileTs Transformation compiling typescript sources to ES2020 modules.
 * @param writePackage Transformation writing a distribution-ready `package.json` (for publishing to npm registry).
 */
const nxEntryPointTransformFactory = (compileTs, writePackage) => (0, rxjs_1.pipe)((0, transform_1.transformFromPromise)((graph) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    // Peek the first entry point from the graph
    const entryPoint = graph.find((0, nodes_1.byEntryPoint)().and(select_1.isInProgress));
    devkit_1.logger.info('\n------------------------------------------------------------------------------');
    devkit_1.logger.info(`Building entry point '${entryPoint.data.entryPoint.moduleId}'`);
    devkit_1.logger.info('------------------------------------------------------------------------------');
})), 
// TypeScript sources compilation
compileTs, 
// After TypeScript: write package
writePackage, (0, transform_1.transformFromPromise)((graph) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    const entryPoint = graph.find((0, nodes_1.byEntryPoint)().and(select_1.isInProgress));
    entryPoint.state = node_1.STATE_DONE;
})));
exports.nxEntryPointTransformFactory = nxEntryPointTransformFactory;
//# sourceMappingURL=entry-point.transform.js.map