/**
 * Adapted from the original ng-packagr source.
 *
 * Changes made:
 * - Removed writing bundles as we don't generate them for incremental builds.
 */
import type { Transform } from 'ng-packagr/lib/graph/transform';
/**
 * A re-write of the `transformSources()` script that transforms an entry point from sources to distributable format.
 *
 * Sources are TypeScript source files accompanied by HTML templates and xCSS stylesheets.
 * See the Angular Package Format for a detailed description of what the distributables include.
 *
 * The current transformation pipeline can be thought of as:
 *
 *  - clean
 *  - compileTs
 *  - downlevelTs
 *  - relocateSourceMaps
 *  - writePackage
 *    - copyStagedFiles (esm, dts, sourcemaps)
 *    - writePackageJson
 *
 * The transformation pipeline is pluggable through the dependency injection system.
 * Sub-transformations are passed to this factory function as arguments.
 *
 * @param compileTs Transformation compiling typescript sources to ES2020 modules.
 * @param writePackage Transformation writing a distribution-ready `package.json` (for publishing to npm registry).
 */
export declare const nxEntryPointTransformFactory: (compileTs: Transform, writePackage: Transform) => Transform;
