"use strict";
/**
 * Adapted from the original ngPackagr source.
 *
 * Changes made:
 * - Use our own StylesheetProcessor files instead of the ones provide by ng-packagr.
 * - Excludes the ngcc compilation for faster builds.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.nxCompileNgcTransformFactory = void 0;
const tslib_1 = require("tslib");
const transform_1 = require("ng-packagr/lib/graph/transform");
const nodes_1 = require("ng-packagr/lib/ng-package/nodes");
const tsconfig_1 = require("ng-packagr/lib/ts/tsconfig");
const path = require("path");
const ts = require("typescript");
const compile_source_files_1 = require("../../ngc/compile-source-files");
const nxCompileNgcTransformFactory = (StylesheetProcessor, options) => {
    return (0, transform_1.transformFromPromise)((graph) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
        var _a;
        var _b;
        try {
            const entryPoint = graph.find((0, nodes_1.isEntryPointInProgress)());
            const entryPoints = graph.filter(nodes_1.isEntryPoint);
            // Add paths mappings for dependencies
            const tsConfig = (0, tsconfig_1.setDependenciesTsConfigPaths)(entryPoint.data.tsConfig, entryPoints);
            // Compile TypeScript sources
            const { esm2020, declarations } = entryPoint.data.destinationFiles;
            const { basePath, cssUrl, styleIncludePaths } = entryPoint.data.entryPoint;
            const { moduleResolutionCache } = entryPoint.cache;
            (_a = (_b = entryPoint.cache).stylesheetProcessor) !== null && _a !== void 0 ? _a : (_b.stylesheetProcessor = new StylesheetProcessor(basePath, cssUrl, styleIncludePaths, options.cacheEnabled && options.cacheDirectory, options.watch, options.tailwindConfig));
            yield (0, compile_source_files_1.compileSourceFiles)(graph, tsConfig, moduleResolutionCache, {
                outDir: path.dirname(esm2020),
                declarationDir: path.dirname(declarations),
                declaration: true,
                target: ts.ScriptTarget.ES2020,
            }, entryPoint.cache.stylesheetProcessor, null, options.watch);
        }
        catch (error) {
            throw error;
        }
        return graph;
    }));
};
exports.nxCompileNgcTransformFactory = nxCompileNgcTransformFactory;
//# sourceMappingURL=compile-ngc.transform.js.map