"use strict";
/**
 * Adapted from the original ng-packagr source.
 *
 * Changes made:
 * - Use our own compileNgcTransformFactory instead of the one provided by ng-packagr.
 * - Use NX_STYLESHEET_PROCESSOR instead of STYLESHEET_PROCESSOR.
 * - Use NX_STYLESHEET_PROCESSOR_TOKEN instead of STYLESHEET_PROCESSOR_TOKEN.
 * - USE NX_OPTIONS_TOKEN instead of OPTIONS_TOKEN.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.NX_COMPILE_NGC_PROVIDERS = exports.NX_COMPILE_NGC_TRANSFORM = exports.NX_COMPILE_NGC_TOKEN = void 0;
const injection_js_1 = require("injection-js");
const transform_di_1 = require("ng-packagr/lib/graph/transform.di");
const stylesheet_processor_di_1 = require("../../styles/stylesheet-processor.di");
const options_di_1 = require("../options.di");
const compile_ngc_transform_1 = require("./compile-ngc.transform");
exports.NX_COMPILE_NGC_TOKEN = new injection_js_1.InjectionToken(`nx.v1.compileNgc`);
exports.NX_COMPILE_NGC_TRANSFORM = (0, transform_di_1.provideTransform)({
    provide: exports.NX_COMPILE_NGC_TOKEN,
    useFactory: compile_ngc_transform_1.nxCompileNgcTransformFactory,
    deps: [stylesheet_processor_di_1.NX_STYLESHEET_PROCESSOR_TOKEN, options_di_1.NX_OPTIONS_TOKEN],
});
exports.NX_COMPILE_NGC_PROVIDERS = [
    stylesheet_processor_di_1.NX_STYLESHEET_PROCESSOR,
    exports.NX_COMPILE_NGC_TRANSFORM,
];
//# sourceMappingURL=compile-ngc.di.js.map