"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.delegateBuildExecutor = void 0;
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const devkit_2 = require("@nrwl/devkit");
const buildable_libs_utils_1 = require("@nrwl/workspace/src/utilities/buildable-libs-utils");
function delegateBuildExecutor(options, context) {
    return tslib_1.__asyncGenerator(this, arguments, function* delegateBuildExecutor_1() {
        const { target, dependencies } = (0, buildable_libs_utils_1.calculateProjectDependencies)((0, devkit_2.readCachedProjectGraph)(), context.root, context.projectName, context.targetName, context.configurationName);
        options.tsConfig = (0, buildable_libs_utils_1.createTmpTsConfig)((0, devkit_1.joinPathFragments)(context.root, options.tsConfig), context.root, target.data.root, dependencies);
        if (!(0, buildable_libs_utils_1.checkDependentProjectsHaveBeenBuilt)(context.root, context.projectName, context.targetName, dependencies)) {
            return yield tslib_1.__await({ success: false });
        }
        const { buildTarget } = options, targetOptions = tslib_1.__rest(options, ["buildTarget"]);
        const delegateTarget = (0, devkit_1.parseTargetString)(buildTarget);
        yield tslib_1.__await(yield* tslib_1.__asyncDelegator(tslib_1.__asyncValues(yield tslib_1.__await((0, devkit_1.runExecutor)(delegateTarget, targetOptions, context)))));
    });
}
exports.delegateBuildExecutor = delegateBuildExecutor;
exports.default = delegateBuildExecutor;
//# sourceMappingURL=delegate-build.impl.js.map