"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.webpackServer = void 0;
const tslib_1 = require("tslib");
const architect_1 = require("@angular-devkit/architect");
const dev_server_1 = require("@angular-devkit/build-angular/src/builders/dev-server");
const devkit_1 = require("@nrwl/devkit");
const fs_1 = require("fs");
const webpack_merge_1 = require("webpack-merge");
const webpack_1 = require("../utilities/webpack");
const lib_1 = require("./lib");
function webpackServer(schema, context) {
    var _a;
    process.env.NX_TSCONFIG_PATH = (0, devkit_1.joinPathFragments)(context.workspaceRoot, 'tsconfig.base.json');
    const options = (0, lib_1.normalizeOptions)(schema);
    const workspaceConfig = new devkit_1.Workspaces(context.workspaceRoot).readWorkspaceConfiguration();
    const parsedBrowserTarget = (0, devkit_1.parseTargetString)(options.browserTarget);
    const buildTarget = workspaceConfig.projects[parsedBrowserTarget.project].targets[parsedBrowserTarget.target];
    const selectedConfiguration = parsedBrowserTarget.configuration
        ? buildTarget.configurations[parsedBrowserTarget.configuration]
        : buildTarget.defaultConfiguration
            ? buildTarget.configurations[buildTarget.defaultConfiguration]
            : buildTarget.options;
    const customWebpackConfig = (_a = selectedConfiguration.customWebpackConfig) !== null && _a !== void 0 ? _a : buildTarget.options.customWebpackConfig;
    if (customWebpackConfig && customWebpackConfig.path) {
        const pathToWebpackConfig = (0, devkit_1.joinPathFragments)(context.workspaceRoot, customWebpackConfig.path);
        if ((0, fs_1.existsSync)(pathToWebpackConfig)) {
            return (0, dev_server_1.serveWebpackBrowser)(options, context, {
                webpackConfiguration: (baseWebpackConfig) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                    const customWebpackConfiguration = (0, webpack_1.resolveCustomWebpackConfig)(pathToWebpackConfig, buildTarget.options.tsConfig);
                    // The extra Webpack configuration file can also export a Promise, for instance:
                    // `module.exports = new Promise(...)`. If it exports a single object, but not a Promise,
                    // then await will just resolve that object.
                    const config = yield customWebpackConfiguration;
                    // The extra Webpack configuration file can export a synchronous or asynchronous function,
                    // for instance: `module.exports = async config => { ... }`.
                    if (typeof config === 'function') {
                        return config(baseWebpackConfig, selectedConfiguration, context.target);
                    }
                    else {
                        return (0, webpack_merge_1.merge)(baseWebpackConfig, config);
                    }
                }),
            });
        }
        else {
            throw new Error(`Custom Webpack Config File Not Found!\nTo use a custom webpack config, please ensure the path to the custom webpack file is correct: \n${pathToWebpackConfig}`);
        }
    }
    return (0, dev_server_1.serveWebpackBrowser)(options, context);
}
exports.webpackServer = webpackServer;
exports.default = (0, architect_1.createBuilder)(webpackServer);
//# sourceMappingURL=webpack-server.impl.js.map