"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const architect_1 = require("@angular-devkit/architect");
const build_angular_1 = require("@angular-devkit/build-angular");
const devkit_1 = require("@nrwl/devkit");
const devkit_2 = require("@nrwl/devkit");
const buildable_libs_utils_1 = require("@nrwl/workspace/src/utilities/buildable-libs-utils");
const fs_1 = require("fs");
const path_1 = require("path");
const rxjs_1 = require("rxjs");
const operators_1 = require("rxjs/operators");
const webpack_merge_1 = require("webpack-merge");
const webpack_1 = require("../utilities/webpack");
function buildApp(options, context) {
    const { buildLibsFromSource, customWebpackConfig } = options, delegateOptions = tslib_1.__rest(options, ["buildLibsFromSource", "customWebpackConfig"]);
    // If there is a path to custom webpack config
    // Invoke our own support for custom webpack config
    if (customWebpackConfig && customWebpackConfig.path) {
        const pathToWebpackConfig = (0, devkit_1.joinPathFragments)(context.workspaceRoot, customWebpackConfig.path);
        if ((0, fs_1.existsSync)(pathToWebpackConfig)) {
            return buildAppWithCustomWebpackConfiguration(delegateOptions, context, pathToWebpackConfig);
        }
        else {
            throw new Error(`Custom Webpack Config File Not Found!\nTo use a custom webpack config, please ensure the path to the custom webpack file is correct: \n${pathToWebpackConfig}`);
        }
    }
    return (0, build_angular_1.executeBrowserBuilder)(delegateOptions, context);
}
function buildAppWithCustomWebpackConfiguration(options, context, pathToWebpackConfig) {
    return (0, build_angular_1.executeBrowserBuilder)(options, context, {
        webpackConfiguration: (baseWebpackConfig) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            const customWebpackConfiguration = (0, webpack_1.resolveCustomWebpackConfig)(pathToWebpackConfig, options.tsConfig);
            // The extra Webpack configuration file can also export a Promise, for instance:
            // `module.exports = new Promise(...)`. If it exports a single object, but not a Promise,
            // then await will just resolve that object.
            const config = yield customWebpackConfiguration;
            // The extra Webpack configuration file can export a synchronous or asynchronous function,
            // for instance: `module.exports = async config => { ... }`.
            if (typeof config === 'function') {
                return config(baseWebpackConfig, options, context.target);
            }
            else {
                return (0, webpack_merge_1.merge)(baseWebpackConfig, config);
            }
        }),
    });
}
function run(options, context) {
    var _a;
    (_a = options.buildLibsFromSource) !== null && _a !== void 0 ? _a : (options.buildLibsFromSource = true);
    let dependencies;
    if (!options.buildLibsFromSource) {
        const result = (0, buildable_libs_utils_1.calculateProjectDependencies)((0, devkit_2.readCachedProjectGraph)(), context.workspaceRoot, context.target.project, context.target.target, context.target.configuration);
        dependencies = result.dependencies;
        options.tsConfig = (0, buildable_libs_utils_1.createTmpTsConfig)((0, path_1.join)(context.workspaceRoot, options.tsConfig), context.workspaceRoot, result.target.data.root, dependencies);
        process.env.NX_TSCONFIG_PATH = options.tsConfig;
    }
    return (0, rxjs_1.of)(!options.buildLibsFromSource
        ? (0, buildable_libs_utils_1.checkDependentProjectsHaveBeenBuilt)(context.workspaceRoot, context.target.project, context.target.target, dependencies)
        : true).pipe((0, operators_1.switchMap)((result) => {
        if (result) {
            return buildApp(options, context);
        }
        else {
            // just pass on the result
            return (0, rxjs_1.of)({ success: false });
        }
    }));
}
exports.default = (0, architect_1.createBuilder)(run);
//# sourceMappingURL=webpack-browser.impl.js.map