"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.unparseMarble = void 0;
function unparseMarble(result, assignSymbolFn) {
    var FRAME_TIME_FACTOR = 10; // need to be up to date with `TestScheduler.frameTimeFactor`
    var frames = 0;
    var marble = '';
    var isInGroup = false;
    var groupMembersAmount = 0;
    var index = 0;
    var isNextMessageInTheSameFrame = function () {
        var nextMessage = result[index + 1];
        return nextMessage && nextMessage.frame === result[index].frame;
    };
    result.forEach(function (testMessage, i) {
        index = i;
        var framesDiff = testMessage.frame - frames;
        var emptyFramesAmount = framesDiff > 0 ? framesDiff / FRAME_TIME_FACTOR : 0;
        marble += '-'.repeat(emptyFramesAmount);
        if (isNextMessageInTheSameFrame()) {
            if (!isInGroup) {
                marble += '(';
            }
            isInGroup = true;
        }
        switch (testMessage.notification.kind) {
            case 'N':
                marble += assignSymbolFn(testMessage.notification);
                break;
            case 'E':
                marble += '#';
                break;
            case 'C':
                marble += '|';
                break;
        }
        if (isInGroup) {
            groupMembersAmount += 1;
        }
        if (!isNextMessageInTheSameFrame() && isInGroup) {
            marble += ')';
            isInGroup = false;
            frames += (groupMembersAmount + 1) * FRAME_TIME_FACTOR;
            groupMembersAmount = 0;
        }
        else {
            frames = testMessage.frame + FRAME_TIME_FACTOR;
        }
    });
    return marble;
}
exports.unparseMarble = unparseMarble;
//# sourceMappingURL=marble-unparser.js.map